<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Schematron schema for validation of authentication tokens.
    This schema is intended as a development aid for building AORTA-compliant SAML tokens.
    It is not intended as a fully functional production-quality security check.
    
    For now the queryBinding SHALL be xslt (Schematron default), because the XSG from CSC
    does not support XSLT 2.0
    This meant removal of the include xml.sch, because that heavily relies on xslt2
    
    Copyright 2008-2010, Nictiz
-->
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van SAML Assertion in een SOAP Header</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <ns uri="http://www.aortarelease.nl/805/" prefix="ao"/>
    <ns uri="http://schemas.xmlsoap.org/soap/envelope/" prefix="soap"/>
    <ns uri="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd" prefix="wsse"/>
    <ns uri="urn:oasis:names:tc:SAML:2.0:assertion" prefix="saml"/>
    <ns uri="http://www.w3.org/2000/09/xmldsig#" prefix="xmlds"/>
    <!--include href="coreschematron/xml.sch"/-->
    <pattern>
        <title>SAML Assertion</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion">
            <let name="samlId" value="concat('token_',//hl7:*[hl7:interactionId][1]/hl7:id/@root,'_',//hl7:*[hl7:interactionId][1]/hl7:id/@extension)"/>
            <assert role="error" test="@Version='2.0'">@Version moet aanwezig en de waarde '2.0' hebben</assert>
            <report role="warning" test="not(@ID=$samlId)"
                >@ID is niet opgebouwd volgens de aanbevolen methode 'token_messageIdRoot_messageIdExtension', verwacht '<value-of select="$samlId"/>'</report>
            <assert role="error" test="saml:Issuer">Issuer is verplicht</assert>
            <assert role="error" test="xmlds:Signature">Signature in de namespace 'http://www.w3.org/2000/09/xmldsig#' is verplicht</assert>
            <assert role="error" test="saml:Subject">Subject is verplicht</assert>
            <assert role="error" test="saml:Conditions">Conditions is verplicht</assert>
            <assert role="error" test="saml:AuthnStatement">AuthnStatement is verplicht</assert>
            <assert role="error" test="saml:AttributeStatement">AttributeStatement is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature">
            <assert role="error" test="xmlds:KeyInfo"
                >Signature/KeyInfo is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature/Reference</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference">
            <assert role="error" test="@URI=concat('#',/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/@ID)"
                >Signature/SignedInfo/Reference/@URI moet verwijzen naar Assertion/@ID</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Signature/Reference/Transforms</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/xmlds:Signature/xmlds:SignedInfo/xmlds:Reference/xmlds:Transforms">
            <assert role="error" test="xmlds:Transform[@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature']"
                >Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2000/09/xmldsig#enveloped-signature' is verplicht</assert>
            <assert role="error" test="xmlds:Transform[@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#']"
                >Signature/SignedInfo/Reference/Transforms/Transform/@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#' is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Subject/NameID</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Subject/saml:NameID">
            <assert role="error" test="not(.='6B2EBBF2E5290BC')"
                >NameID '6B2EBBF2E5290BC' komt rechtstreeks uit de implementatiehandleiding. Digi-D is verantwoordelijk voor het al of niet aanleveren van deze waarde</assert>
        </rule>
        
        <title>SAML Subject/SubjectConfirmation</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Subject/saml:SubjectConfirmation">
            <assert role="error" test="@Method='urn:oasis:names:tc:SAML:2.0:cm:bearer'"
                >@Method moet de waarde 'urn:oasis:names:tc:SAML:2.0:cm:bearer' hebben</assert>
        </rule>
        
        <title>SAML Subject/SubjectConfirmation/SubjectConfirmationData</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Subject/saml:SubjectConfirmation/saml:SubjectConfirmationData">
            <assert role="error" test="@InResponseTo"
                >@InResponseTo deze is verplicht</assert>
            <assert role="error" test="@NotOnOrAfter"
                >@NotOnOrAfter deze is verplicht</assert>
            <assert role="error" test="@Recipient"
                >@Recipient deze is verplicht</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML Conditions</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions">
            <let name="notBefore" value="xs:integer(format-dateTime(xs:dateTime(@NotBefore), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>
            <let name="notOnOrAfter" value="xs:integer(format-dateTime(xs:dateTime(@NotOnOrAfter), '[Y0001][M01][D01][H01][m01][s01]', 'en', (), ()))"/>
            <assert role="error" test="$notOnOrAfter &gt; $notBefore"
                >Datum @NotBefore moet voor @NotOnOrAfter liggen</assert>
            <assert role="error" test="saml:AudienceRestriction"
                >AudienceRestriction is verplicht</assert>
        </rule>

        <title>SAML Conditions/AudienceRestrictions</title>
        <let name="messageReceiver" value="concat('urn:IIroot:',//hl7:receiver[1]/hl7:device/hl7:id/@root,':IIext:',//hl7:receiver[1]/hl7:device/hl7:id/@extension)"/>
        <let name="messageSender" value="concat('urn:IIroot:',//hl7:sender[1]/hl7:device/hl7:id/@root,':IIext:',//hl7:sender[1]/hl7:device/hl7:id/@extension)"/>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:Conditions[1]/saml:AudienceRestriction[1]">
            <assert role="error" test="count(saml:Audience) = 2"
                >Er moeten 2 Audiences zijn. De ZIM en het GBP</assert>
            <assert role="error" test="saml:Audience[.=$messageReceiver]"
                >Audience ZIM '<value-of select="$messageReceiver"/>' ontbreekt</assert>
            <assert role="error" test="saml:Audience[.=$messageSender]"
                >Audience ZIM '<value-of select="$messageSender"/>' ontbreekt</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML AuthnStatement</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AuthnStatement">
            <assert role="error" test="@AuthnInstant"
                >@AuthnInstant is verplicht</assert>
            <assert role="error" test="@SessionIndex"
                >@SessionIndex is verplicht</assert>
            <assert role="error" test="saml:SubjectLocality"
                >SubjectLocality is verplicht</assert>
            <assert role="error" test="saml:AuthnContext"
                >AuthnContext is verplicht</assert>
        </rule>
        
        <title>SAML AuthnStatement/SubjectLocality</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AuthnStatement/saml:SubjectLocality">
            <assert role="error" test="matches(@Address,'\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}')"
                >SubjectLocality/@Address moet een IP-adres zijn</assert>
        </rule>
        
        <title>SAML AuthnStatement/AuthnContext/AuthnContextClassRef</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AuthnStatement/saml:AuthnContext/saml:AuthnContextClassRef">
            <assert role="error" test="text()='urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract'"
                >Waarde moet 'urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract' zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>SAML AttributeStatement</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]">
            <assert role="error" test="saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue"
                >Attribute/@Name='burgerServiceNummer' moet zijn meegetekend</assert>
            <assert role="error" test="saml:Attribute[@Name='authenticatieSterkte']/saml:AttributeValue"
                >Attribute/@Name='authenticatieSterkte' moet zijn meegetekend</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (burgerServiceNummer)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='burgerServiceNummer']/saml:AttributeValue">
            <let name="codeValue" value="text()"/>
            <let name="patientId" value="//hl7:*[@root='2.16.840.1.113883.2.4.6.3']/@extension"/>
            <assert role="error" test=". = $patientId"
                >Attribute burgerServiceNummer '<value-of select="$codeValue"/>' moet overeenkomen met verwachte waarde 
                '<value-of select="$patientId"/>'</assert>
        </rule>
        
        <title>SAML AttributeStatement/Attribute (authenticatieSterkte)</title>
        <rule context="/soap:Envelope/soap:Header[1]/wsse:Security[1]/saml:Assertion/saml:AttributeStatement[1]/saml:Attribute[@Name='authenticatieSterkte']/saml:AttributeValue">
            <assert role="error" test=".='22'"
                >Attribute authenticatieSterkte '<value-of select="."/>' moet overeenkomen met verwachte waarde '22' (22=Midden-plus)</assert>
        </rule>
        
    </pattern>
</schema>
